#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/mo
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
; #AutoIt3Wrapper_AU3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#Region Header
;Simple Library Docs Generator - Program by G.Sandler (a.k.a CreatoR).

;#RequireAdmin

#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <Array.au3>
#include <File.au3>
#include <String.au3>

#include "Includes\Au3SyntaxHighlight.au3"

Opt("MustDeclareVars", 1)
#EndRegion Header

#Region Global Variables
Global $sAppName = "Simple Library Docs Generator"
Global $sAppRegKey = "HKEY_CURRENT_USER\Software\" & $sAppName

;×èòàåì ïîñëåäíèå ââåä¸ííûå äàííûå ïðîãðàììû
Global $sLibraryFile = _RegRead($sAppRegKey, "Library File", "")
Global $sLibExamplesDir = _RegRead($sAppRegKey, "Library Examples Dir", StringRegExpReplace($sLibraryFile, "\\[^\\]*$", ""))
Global $sDocsDir = _RegRead($sAppRegKey, "Docs Dir", "")
Global $sDocsIndex_Title = _RegRead($sAppRegKey, "Docs Index Title", "UDF Library")
Global $sDocsIndexHeader_Title = _RegRead($sAppRegKey, "Docs Index Header Title", "UDF Library")
Global $sDocsFunc_Title = _RegRead($sAppRegKey, "Docs Func Title", "Function Reference [%IndexTitle% - %FuncName%]")
Global $sDocsFuncHeader_Title = _RegRead($sAppRegKey, "Docs Func Header Title", "Function Reference")
Global $iShowGeneratedDocs = _RegRead($sAppRegKey, "Show Generated Docs", 0)
Global $iHighlightExampleSyntax = _RegRead($sAppRegKey, "Highlight Example Syntax", 0)
Global $iHiglExmplSyntx_AddURLs = _RegRead($sAppRegKey, "Highlight Example Syntax Add URLs", 1)
Global $iCompileToChm = _RegRead($sAppRegKey, "Compile To Chm", 0)

Global $hGUI, $nLibraryFile_Button, $nLibraryFile_Input, $nDocsDir_Button, $nDocsDir_Input, $nLibExamplesDir_Button, $nLibExamplesDir_Input, $sInitial_Dir, $sDir, $sLibraryFile_Name
Global $nDocsIndexTitle_Input, $nDocsIndexHeaderTitle_Input, $nDocsFuncTitle_Input, $nDocsFuncHeaderTitle_Input
Global $nShowGeneratedDocs_CB, $nHighlightExampleSyntax_CB, $nHiglExmplSyntx_AddURLs_CB, $nCompileToChm_CB, $nStatus_Label, $nGenerateDocs_Button, $nExit_Button
#EndRegion Global Variables

#Region GUI Creation & Main Loop
$hGUI = GUICreate($sAppName, 400, 450, -1, -1, -1, $WS_EX_TOPMOST)

GUICtrlCreateLabel("Au3 Library File:", 20, 5, -1, 15)
$nLibraryFile_Button = GUICtrlCreateButton("...", 360, 20, 20, 20)
$nLibraryFile_Input = GUICtrlCreateInput($sLibraryFile, 20, 20, 340, 20)

GUICtrlCreateLabel("Au3 Library Examples Dir:", 20, 45, -1, 15)
$nLibExamplesDir_Button = GUICtrlCreateButton("...", 360, 60, 20, 20)
$nLibExamplesDir_Input = GUICtrlCreateInput($sLibExamplesDir, 20, 60, 340, 20)

GUICtrlCreateLabel("Au3 Library Documents Output Dir:", 20, 85, -1, 15)
$nDocsDir_Button = GUICtrlCreateButton("...", 360, 100, 20, 20)
$nDocsDir_Input = GUICtrlCreateInput($sDocsDir, 20, 100, 340, 20)

GUICtrlCreateGroup("Title Formats", 10, 123, 380, 175)

GUICtrlCreateLabel("Document Index Title" & @CRLF & "(Browser Title)", 20, 140, -1, 27)
$nDocsIndexTitle_Input = GUICtrlCreateInput($sDocsIndex_Title, 20, 170, 170, 20)

GUICtrlCreateLabel("Document Index Header Title" & @CRLF & "(<h1> element)", 210, 140, -1, 27)
$nDocsIndexHeaderTitle_Input = GUICtrlCreateInput($sDocsIndexHeader_Title, 210, 170, 170, 20)

GUICtrlCreateLabel("Document Function Title" & @CRLF & "(Browser Title)", 20, 200, -1, 27)
$nDocsFuncTitle_Input = GUICtrlCreateInput($sDocsFunc_Title, 20, 230, 170, 20)

GUICtrlCreateLabel("Document Function Header Title" & @CRLF & "(<h1> element)", 210, 200, -1, 27)
$nDocsFuncHeaderTitle_Input = GUICtrlCreateInput($sDocsFuncHeader_Title, 210, 230, 170, 20)

GUICtrlCreateLabel( _
		"%IndexTitle% 		= Document Index Title" & @CRLF & _
		"%IndexHeaderTitle% 	= Document Index Header Title" & @CRLF & _
		"%FuncName% 		= Function Name (current function in the list)", 20, 255, 360, 37)

GUICtrlSetFont(-1, 8, 200, 0, "Tahoma")
GUICtrlSetColor(-1, 0x0000FF)

GUICtrlCreateGroup("Options", 10, 300, 380, 110)

$nShowGeneratedDocs_CB = GUICtrlCreateCheckbox("Show Generated Docs", 20, 320, -1, 15)
If $iShowGeneratedDocs = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)

$nHighlightExampleSyntax_CB = GUICtrlCreateCheckbox("Highlight Example Syntax (!Not Recomended -> longer than usual)", 20, 340, -1, 15)
If $iHighlightExampleSyntax = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)

$nHiglExmplSyntx_AddURLs_CB = GUICtrlCreateCheckbox("Add URLs to online docs for built-in functions", 40, 360, -1, 15)
If $iHiglExmplSyntx_AddURLs = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)
If $iHighlightExampleSyntax <> 1 Then GUICtrlSetState(-1, $GUI_DISABLE)

$nCompileToChm_CB = GUICtrlCreateCheckbox("Compile Document To Chm Help File", 20, 385, -1, 15)
If $iCompileToChm = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)

$nStatus_Label = GUICtrlCreateLabel("", 230, 410, 130, 27)
GUICtrlSetFont(-1, 8.5, 800, 0, "Georgia")
GUICtrlSetColor(-1, 0xFF0000)

$nGenerateDocs_Button = GUICtrlCreateButton("Generate", 20, 420, 60, 20)
$nExit_Button = GUICtrlCreateButton("Exit", 100, 420, 60, 20)

GUISetState(@SW_SHOW, $hGUI)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE, $nExit_Button
			Exit
		Case $nLibraryFile_Button
			Global $sFile = FileOpenDialog("Select Au3 Library File", "", "AutoIt Script File (*.au3)", 0, "", $hGUI)
			If @error Then ContinueLoop

			GUICtrlSetData($nLibraryFile_Input, $sFile)
		Case $nLibExamplesDir_Button
			$sInitial_Dir = GUICtrlRead($nLibExamplesDir_Input)
			If Not FileExists($sInitial_Dir) Then $sInitial_Dir = @WorkingDir

			$sDir = FileSelectFolder("Select Au3 Library Examples Directory", "", 3, $sInitial_Dir, $hGUI)
			If @error Or Not StringInStr($sDir, "\") Or Not FileExists($sDir) Then ContinueLoop

			GUICtrlSetData($nLibExamplesDir_Input, $sDir)
		Case $nDocsDir_Button
			$sInitial_Dir = GUICtrlRead($nDocsDir_Input)
			If Not FileExists($sInitial_Dir) Then $sInitial_Dir = @WorkingDir

			$sDir= FileSelectFolder("Select Au3 Documents Output Directory", "", 3, $sInitial_Dir, $hGUI)
			If @error Or Not StringInStr($sDir, "\") Or Not FileExists($sDir) Then ContinueLoop

			GUICtrlSetData($nDocsDir_Input, $sDir)
		Case $nHighlightExampleSyntax_CB
			If GUICtrlRead($nHighlightExampleSyntax_CB) = $GUI_CHECKED Then
				GUICtrlSetState($nHiglExmplSyntx_AddURLs_CB, $GUI_ENABLE)
			Else
				GUICtrlSetState($nHiglExmplSyntx_AddURLs_CB, $GUI_DISABLE)
			EndIf
		Case $nGenerateDocs_Button
			$sLibraryFile = GUICtrlRead($nLibraryFile_Input)
			$sLibExamplesDir = GUICtrlRead($nLibExamplesDir_Input)

			$sDocsDir = GUICtrlRead($nDocsDir_Input)
			$sDocsIndex_Title = GUICtrlRead($nDocsIndexTitle_Input)
			$sDocsIndexHeader_Title = GUICtrlRead($nDocsIndexHeaderTitle_Input)
			$sDocsFunc_Title = GUICtrlRead($nDocsFuncTitle_Input)
			$sDocsFuncHeader_Title = GUICtrlRead($nDocsFuncHeaderTitle_Input)

			$iShowGeneratedDocs = Number(GUICtrlRead($nShowGeneratedDocs_CB) = $GUI_CHECKED)
			$iHighlightExampleSyntax = Number(GUICtrlRead($nHighlightExampleSyntax_CB) = $GUI_CHECKED)
			$iHiglExmplSyntx_AddURLs = Number(GUICtrlRead($nHiglExmplSyntx_AddURLs_CB) = $GUI_CHECKED)
			$iCompileToChm = Number(GUICtrlRead($nCompileToChm_CB) = $GUI_CHECKED)

			If Not FileExists($sLibraryFile) Then
				MsgBox(48, 'Attention', 'Library File Does Not Exists.', 0, $hGUI)
				ContinueLoop
			EndIf
			$sLibraryFile_Name = StringRegExpReplace($sLibraryFile, "^.*\\|\.[^\.]*$", "") ;FileName (without the extension)

			GUICtrlSetData($nStatus_Label, "Please wait... [Generating Docs]")
			GUICtrlSetState($nGenerateDocs_Button, $GUI_DISABLE)
			GUICtrlSetState($nExit_Button, $GUI_DISABLE)

			;Âêëþ÷àåì ðåæèì ñîáûòèé (OnEvent) ÷òîáû êîððåêòíî îáðàáàòûâàòü ïóíêò "Highlight Example Syntax" è "Add URLs to online docs"
			Opt("GUIOnEventMode", 1)

			;Çàäà¸ì ñîáûòèå äëÿ ýòèõ ïóíêòîâ
			GUICtrlSetOnEvent($nHighlightExampleSyntax_CB, "_HighlightExampleSyntax_CB_Event")
			GUICtrlSetOnEvent($nHiglExmplSyntx_AddURLs_CB, "_HighlightExampleSyntax_CB_Event")

			Global $sIndex_File = _AU3Lib_GenerateDocs_Proc()

			;Îòêëþ÷àåì ðåæèì ñîáûòèé (OnEvent)
			Opt("GUIOnEventMode", 0)

			If $iCompileToChm Then
				$sIndex_File = $sDocsDir & "\" & $sLibraryFile_Name & ".chm"
				_AU3Lib_CompileHtmlToChm($sDocsDir, $sLibraryFile_Name)
			EndIf

			If $iShowGeneratedDocs Then
				ShellExecute($sIndex_File)
			EndIf

			GUICtrlSetData($nStatus_Label, @CRLF & "Done!")
			GUICtrlSetState($nGenerateDocs_Button, $GUI_ENABLE)
			GUICtrlSetState($nExit_Button, $GUI_ENABLE)

			;Ñîõðàíåíèå äàííûõ
			RegWrite($sAppRegKey, "Library File", "REG_SZ", $sLibraryFile)
			RegWrite($sAppRegKey, "Library Examples Dir", "REG_SZ", $sLibExamplesDir)
			RegWrite($sAppRegKey, "Docs Dir", "REG_SZ", $sDocsDir)
			RegWrite($sAppRegKey, "Docs Index Title", "REG_SZ", $sDocsIndex_Title)
			RegWrite($sAppRegKey, "Docs Index Header Title", "REG_SZ", $sDocsIndexHeader_Title)
			RegWrite($sAppRegKey, "Docs Func Title", "REG_SZ", $sDocsFunc_Title)
			RegWrite($sAppRegKey, "Docs Func Header Title", "REG_SZ", $sDocsFuncHeader_Title)
			RegWrite($sAppRegKey, "Show Generated Docs", "REG_SZ", $iShowGeneratedDocs)
			RegWrite($sAppRegKey, "Highlight Example Syntax", "REG_SZ", $iHighlightExampleSyntax)
			RegWrite($sAppRegKey, "Compile To Chm", "REG_SZ", $iCompileToChm)
			RegWrite($sAppRegKey, "Highlight Example Syntax Add URLs", "REG_SZ", $iHiglExmplSyntx_AddURLs)
	EndSwitch
WEnd
#EndRegion GUI Creation & Main Loop

#Region Core Functions
Func _AU3Lib_GenerateDocs_Proc()
	;Îáúÿâëÿåì ïåðåìåííûå
	Local $aHeaders, $sIndex_File, $hIndex_File, $sHtml_Header, $sFuncName, $aParams_Split, $aReturn, $sReturn_Success, $sReturn_Failure, $sRemarks, $aSplit, $sRelated
	Local $sHtml_Content, $sParam_TD_Width, $sValue_TD_Width, $sExample_File, $sExample_Content, $hFunc_File, $sFile
	Local $sDocsFunc_Formatted_Title, $sDocsFuncHeader_Formatted_Title, $sDocsFunc_FormattedTmp_Title, $sDocsFuncHeader_FormattedTmp_Title

	;Ôîðìàòèðóåì çàãîëîâêè äëÿ Html-ñòðàíèö
	$sDocsFunc_Formatted_Title = StringReplace($sDocsFunc_Title, '%IndexTitle%', $sDocsIndex_Title)
	$sDocsFunc_Formatted_Title = StringReplace($sDocsFunc_Formatted_Title, '%IndexHeaderTitle%', $sDocsIndexHeader_Title)
	$sDocsFuncHeader_Formatted_Title = StringReplace($sDocsFuncHeader_Title, '%IndexTitle%', $sDocsIndex_Title)
	$sDocsFuncHeader_Formatted_Title = StringReplace($sDocsFuncHeader_Formatted_Title, '%IndexHeaderTitle%', $sDocsIndexHeader_Title)

	;Ïîëó÷àåìï çàãîëîâêè áèáëèîòåêè
	$aHeaders = _AU3Lib_GetHeaders($sLibraryFile)

	;Ñîçäà¸ì ñòðóêòóðó êàòàëîãîâ
	DirCreate($sDocsDir & "\css")
	DirCreate($sDocsDir & "\funcs")

	;Äîáàâëÿåì ôàéë ñòèëåé è êàðòèíêó äëÿ <h1>
	FileInstall(".\Resources\default.css", $sDocsDir & "\css\default.css", 1)
	FileInstall(".\Resources\h1_background.jpg", $sDocsDir & "\css\h1_background.jpg", 1)

	;Îïðåäåëÿåì ôàéë èíäåêñà
	$sIndex_File = $sDocsDir & "\index.htm"

	;Îòêðûâàåì ôàéë èíäåêñà (â UTF-8)
	$hIndex_File = FileOpen($sIndex_File, 2 + 128)

	;Ïîëó÷àåì ãëàâíûé çàãîëîâîê Html-ôàéëà
	$sHtml_Header = _AU3Lib_GetHtmlHeaderStr($sDocsIndex_Title, 'css')

	;Ïèøåì ñðàçó çàãîëîâîê èíäåêñà
	FileWriteLine($hIndex_File, $sHtml_Header & @CRLF & '<body>' & @CRLF & '<h1>' & $sDocsIndexHeader_Title & '</h1>')
	FileWriteLine($hIndex_File, '<p>Below is a complete list of the functions available in this library. Click on a function name for a detailed description.</p>')
	FileWriteLine($hIndex_File, '<table>') ;~ modified
	;	FileWriteLine($hIndex_File, '<br>') ;~ modified
	FileWriteLine($hIndex_File, '<tr>')
	FileWriteLine($hIndex_File, ' 	<th style="width:25%">Function</th>') ;~ modified
	FileWriteLine($hIndex_File, '	<th style="width:75%">Description</th>') ;~ modified
	FileWriteLine($hIndex_File, '</tr>')

	For $i = 1 To UBound($aHeaders) - 1
		;Ïîëó÷àåì èìÿ ôóíêöèé (äëÿ èìåíè ôàéëà è ññûëêè)
		$sFuncName = $aHeaders[$i][0]

		;Ôîðìàòèðóåì çàãîëîâêè äëÿ Html-ñòðàíèö (òîëüêî äëÿ ôóíêöèé, ò.ê îíà èçìåíÿåòñÿ è ñ÷èòûâàåòñÿ â öèêëå)
		$sDocsFunc_FormattedTmp_Title = StringReplace($sDocsFunc_Formatted_Title, '%FuncName%', $sFuncName)
		$sDocsFuncHeader_FormattedTmp_Title = StringReplace($sDocsFuncHeader_Formatted_Title, '%FuncName%', $sFuncName)

		;Ïîëó÷àåì èìÿ ôàéëà ôóíêöèé
		$sFile = _AU3Lib_GetValidFileName($sFuncName)

		;Ïèøåì òåêóùóþ ññûëêó â èíäåêñ
		FileWriteLine($hIndex_File, '<tr>')
		FileWriteLine($hIndex_File, '	<td><a href="funcs/' & $sFile & '.htm">' & $sFuncName & '</a></td>')
		FileWriteLine($hIndex_File, '	<td>' & $aHeaders[$i][1] & '</td>')
		FileWriteLine($hIndex_File, '</tr>')

		#Region Ïîëó÷àåì è ôîðìàòèðóåì ïàðàìåòðû ôóíêöèé
		$aParams_Split = StringSplit(StringStripCR($aHeaders[$i][3]), @LF)
		Dim $aParams[$aParams_Split[0] + 1], $aValues[$aParams_Split[0] + 1]

		For $j = 1 To $aParams_Split[0]
			If StringIsSpace($aParams_Split[$j]) Then ContinueLoop

			;Ïðîâåðÿåì åñëè òåêóùàÿ ñòðîêà ýòî ñòðîêà ñ ïàðàìåòðîì â íà÷àëå
			If StringRegExp($aParams_Split[$j], "(?:\s+)?(\$[\w\d_]+)\s+-.*") Then
				$aParams[0] += 1
				$aValues[0] += 1

				;Èçâëåêàåì ïàðàìåòð
				$aParams[$aParams[0]] = StringRegExpReplace($aParams_Split[$j], '(?:\s+)?(\$[\w\d_]+)\s+-.*', '\1')

				;Èçâëåêàåì îïèñàíèå ïàðàìåòðà
				$aValues[$aValues[0]] = StringRegExpReplace($aParams_Split[$j], '(?:\s+)?\$[\w\d_]+\s+-\s+(.*)', '\1') & '<br>' & @CRLF
			Else ;Èíà÷å ýòî ïðîäîëæåíèå îïèñàíèÿ ïàðàìåòðà
				$aValues[$aValues[0]] &= $aParams_Split[$j] & '<br>' & @CRLF
			EndIf

			;Çàìåíÿåì â îïèñàíèé ïàðàìåòðà |True/1/False/0 íà 1 è 0
			;$aValues[$aValues[0]] = StringRegExpReplace($aValues[$aValues[0]], '(?i)\|TRUE', '1')
			;$aValues[$aValues[0]] = StringRegExpReplace($aValues[$aValues[0]], '(?i)\|FALSE', '0')
			;$aValues[$aValues[0]] = StringRegExpReplace($aValues[$aValues[0]], '(?i)\|(?:(.+))', '<p style="margin-left: 10pt">\1</p>')
			$aValues[$aValues[0]] = StringRegExpReplace($aValues[$aValues[0]], '(?i)\|(?:(.+))', '\1')
			$aValues[$aValues[0]] = StringRegExpReplace($aValues[$aValues[0]], '(?m)^\h*\+', '<br>')

			;Îáðàìëÿåì â îïèñàíèé ïàðàìåòðà [Opt*] òåãàìè <b></b>
			$aValues[$aValues[0]] = StringRegExpReplace($aValues[$aValues[0]], '(?i)(\[(?:Opt|In|Out)[^\]]*\])', '<b>\1</b>')
		Next

		ReDim $aParams[$aParams[0] + 1]
		ReDim $aValues[$aParams[0] + 1]
		#EndRegion Ïîëó÷àåì è ôîðìàòèðóåì ïàðàìåòðû ôóíêöèé

		#Region Ïîëó÷àåì è ôîðìàòèðóåì âîçâðàùàåìîå çíà÷åíèå ôóíêöèé
		$aReturn = StringRegExp($aHeaders[$i][4], '(?si).*?Success\h*[-:]\h*(.*?)\s+Failure\s*[-:]\s*(.*)', 3)

		If @error Then
			$sReturn_Success = $aHeaders[$i][4]
			$sReturn_Failure = "None."
		Else
			$sReturn_Success = StringReplace($aReturn[0], @CRLF, '<br>' & @CRLF)
			$sReturn_Failure = StringReplace($aReturn[1], @CRLF, '<br>' & @CRLF)
		EndIf

		;Çàìåíÿåì â îïèñàíèé âîçâð. çíà÷åíèÿ |True/1/False/0 íà 1 è 0.
		;$sReturn_Success = StringRegExpReplace($sReturn_Success, '(?i)\|TRUE', '1')
		$sReturn_Success = StringRegExpReplace($sReturn_Success, '(?i)\|\-', '')
		$sReturn_Success = StringRegExpReplace($sReturn_Success, '(?i)\|(?:(.+?))', '\1')
		;$sReturn_Success = StringRegExpReplace($sReturn_Success, '\r?\n', '<br>')
		$sReturn_Success = StringRegExpReplace($sReturn_Success, '<br>\h*\+', '')
		;$sReturn_Failure = StringRegExpReplace($sReturn_Failure, '(?i)\|FALSE', '0')
		$sReturn_Failure = StringRegExpReplace($sReturn_Failure, '(?i)\|\-', '')
		$sReturn_Failure = StringRegExpReplace($sReturn_Failure, '(?i)\|(?:(.+?))', '\1')
		;$sReturn_Failure = StringRegExpReplace($sReturn_Failure, '\r?\n', '<br>')
		$sReturn_Failure = StringRegExpReplace($sReturn_Failure, '<br>\h*\+', '')

		If StringRegExp($sReturn_Success, "^.*?[\r\n]{2}") Then
			$sReturn_Success &= '<br>&nbsp;'
		EndIf
		#EndRegion Ïîëó÷àåì è ôîðìàòèðóåì âîçâðàùàåìîå çíà÷åíèå ôóíêöèé

		#Region Ôîðìèðóåì Html'êó ôóíêöèé
		;			'<hr style="height:0px">' & @CRLF & _  ;~ modified
		; 			'<p>' & $aHeaders[$i][1] & '<br></p>' & @CRLF & _ ;~ modified
		;			'<br />' & @CRLF & _
		$sHtml_Content = _AU3Lib_GetHtmlHeaderStr($sDocsFunc_FormattedTmp_Title, '../css') & _
				'<body><h1 class="small">' & $sDocsFuncHeader_FormattedTmp_Title & '</h1>' & @CRLF & _ ;~ modified
				'<hr style="height:0px">' & @CRLF & _ ;~ modified/inserted
				'<h1>' & $sFuncName & '</h1>' & @CRLF & _
				'<p class="funcdesc">' & $aHeaders[$i][1] & '<br /></p>' & @CRLF & _
				'<p class="codeheader">' & @CRLF & _
				$aHeaders[$i][2] & '<br>' & @CRLF & _
				'</p>' & @CRLF & @CRLF & _
				'<h2>Parameters</h2>' & @CRLF

		If $aParams[0] > 0 Then
			$sHtml_Content &= '<table>' & @CRLF ;~ modified

			$sParam_TD_Width = ' style="width:15%"' ;~ modified
			$sValue_TD_Width = ' style="width:85%"' ;~ modified

			For $j = 1 To $aParams[0]
				If $j > 1 Then
					$sParam_TD_Width = ''
					$sValue_TD_Width = ''
				EndIf

				$sHtml_Content &= _
						'	<tr>' & @CRLF & _
						'		<td' & $sParam_TD_Width & '>' & $aParams[$j] & '</td>' & @CRLF & _
						'		<td' & $sValue_TD_Width & '>' & $aValues[$j] & '</td>' & @CRLF & _
						'	</tr>' & @CRLF
			Next

			$sHtml_Content &= '</table>' & @CRLF & @CRLF
		Else
			$sHtml_Content &= 'None.<br>' & @CRLF
		EndIf

		$sHtml_Content &= '<h2>Return Value</h2>' & @CRLF ;~ modified

		;If $sReturn_Failure = "None." Then
		;	$sHtml_Content &= $sReturn_Success & '<br>' & @CRLF
		;Else
		$sHtml_Content &= _
				'<table class="noborder">' & @CRLF & _  ;~ modified
				'	<tr>' & @CRLF & _
				'		<td style="width:10%" class="valign-top">Success:</td>' & @CRLF & _
				'		<td style="width:90%">' & $sReturn_Success & '</td>' & @CRLF & _
				'	</tr>' & @CRLF & _
				'	<tr>' & @CRLF & _
				'		<td class="valign-top">Failure:</td>' & @CRLF & _
				'		<td>' & $sReturn_Failure & '</td>' & @CRLF & _
				'	</tr>' & @CRLF & _
				'</table>' & @CRLF
		;EndIf

		If $aHeaders[$i][7] <> '' Then ;~ modified
			$sRemarks = StringReplace($aHeaders[$i][7], @CRLF, '<br>' & @CRLF)
			;$sRemarks = StringRegExpReplace($sRemarks, '(?i)\|TRUE', '1')
			;	 		$sRemarks = StringRegExpReplace($sRemarks, '(?i)\|(?:(.+))', '\1')
			$sRemarks = StringRegExpReplace($sRemarks, '(?m)^\h*\+', '&nbsp;') ;~ modified

			$sHtml_Content &= _
					@CRLF & '<h2>Remarks</h2>' & @CRLF & _ ;~ modified
					$sRemarks & '<br>' & @CRLF & @CRLF ;~ modified
		EndIf ;~ modified

		If $aHeaders[$i][8] <> '' Then
			$aSplit = StringRegExp($aHeaders[$i][8], '(\w+)', 3)
			$aHeaders[$i][8] = ''

			For $j = 0 To UBound($aSplit) - 1
				$aHeaders[$i][8] &= ($aHeaders[$i][8] ? ', ' : '') & '<a href="' & $aSplit[$j] & '.htm">' & $aSplit[$j] & '</a>'
			Next

			$sRelated = StringReplace($aHeaders[$i][8], @CRLF, '<br>' & @CRLF)
			;$sRelated = StringRegExpReplace($sRelated, '(?i)\|TRUE', '1')
			$sRelated = StringRegExpReplace($sRelated, '(?i)\|(?:(.+))', '\1')

			$sHtml_Content &= _
					'<h2>Related</h2>' & @CRLF & _
					$sRelated & '<br>' & @CRLF
		EndIf

		;Ïèøåì ïðèìåð ôóíêöèé
		$sExample_File = $sLibExamplesDir & "\" & $sFile & ".au3"

		If ($aHeaders[$i][10] = "Yes" And FileExists($sExample_File)) Or FileExists($aHeaders[$i][10]) Then
			$sHtml_Content &= @CRLF & '<h2>Example</h2>' & @CRLF ;~ modified

			If $aHeaders[$i][10] <> "Yes" Then $sExample_File = $aHeaders[$i][10]

			If $iHighlightExampleSyntax Then
				$iAu3SH_AddURLs = $iHiglExmplSyntx_AddURLs
				$sExample_Content = _Au3_SyntaxHighlight_Proc(FileRead($sExample_File), 2)
			Else
				$sExample_Content = FileRead($sExample_File)
			EndIf

			$sExample_Content = StringStripWS($sExample_Content, 3)
			$sExample_Content = StringReplace($sExample_Content, '<>', '&lt;&gt;')

			If Not $iHighlightExampleSyntax Then
				$sExample_Content = StringReplace($sExample_Content, '<', '&lt;')
				$sExample_Content = StringReplace($sExample_Content, '>', '&gt;')
				$sExample_Content = StringReplace($sExample_Content, @CRLF, '<br>')
			EndIf

			If $sExample_Content <> "" Then
				#cs OLD Version
								$sHtml_Content &= _
									'<pre id="copytext" class="codebox"><span>' & @CRLF & _
									$sExample_Content & @CRLF & _
									'</span></pre>' & @CRLF & _
									'<SCRIPT LANGUAGE="JavaScript">' & @CRLF & _
									'	if ((navigator.appName=="Microsoft Internet Explorer") && (parseInt(navigator.appVersion)>=4)) // IE (4+) only' & @CRLF & _
									'	{' & @CRLF & _
									'		document.write(''<TEXTAREA ID="holdtext" STYLE="display:none;"></TEXTAREA>'');' & @CRLF & _
									'		document.write(''<BUTTON onClick="CopyProc();">Copy to Clipboard</BUTTON>'');' & @CRLF & _
									'		function CopyProc(){holdtext.innerText = copytext.innerText;Copied = holdtext.createTextRange();Copied.execCommand("Copy");}' & @CRLF & _
									'	}' & @CRLF & _
									'</SCRIPT>' & @CRLF
				#ce OLD Version
				$sHtml_Content &= _
						'<script type="text/javascript">' & @CRLF & _
						'if ((navigator.appName == "Microsoft Internet Explorer") && (parseInt(navigator.appVersion) >= 4)) // IE (4+) only' & @CRLF & _
						'function copyToClipboard(section) {' & @CRLF & _
						'if (window.clipboardData && clipboardData.setData) {' & @CRLF & _
						'clipboardData.setData("text", section + "\r\n");' & @CRLF & _
						'alert("Copied to clipboard");' & @CRLF & _
						'}' & @CRLF & _
						'}' & @CRLF & _
						'</script>' & @CRLF & _
						'<div class="codeSnippetContainer">' & @CRLF & _
						'	<div class="codeSnippetContainerTabs">' & @CRLF & _
						'<script type="text/javascript">' & @CRLF & _
						'if (document.URL.match(/^mk:@MSITStore:/i)) {' & @CRLF & _
						'document.write(''<div class="codeSnippetContainerTab codeSnippetContainerTabSingle" dir="ltr">'');' & @CRLF & _
						'document.write(''<object id=hhctrl type="application/x-oleobject" classid="clsid:adb880a6-d8ff-11cf-9377-00aa003b7a11"><param name="Command" value="ShortCut"><param name="Font" value="Verdana,10pt"><param name="Text" value="Text:Open this Script"><param name="Item1" value=",Examples\\' & $sFuncName & '.au3,"></object>'');' & @CRLF & _
						'document.write(''<\/div>'');' & @CRLF & _
						'}' & @CRLF & _
						'</script>' & @CRLF & _
						'</div>' & @CRLF & _
						' ' & @CRLF & _
						'<div class="codeSnippetContainerCodeContainer">' & @CRLF & _
						'<div class="codeSnippetToolBar">' & @CRLF & _
						'<div class="codeSnippetToolBarText">' & @CRLF & _
						'<script type="text/javascript">' & @CRLF & _
						'if ((navigator.appName == "Microsoft Internet Explorer") && (parseInt(navigator.appVersion) >= 4)) // IE (4+) only' & @CRLF & _
						'document.write(''<a href="#" id="copy" onclick="copyToClipboard(document.getElementById(\''copytext1\'').innerText)">Copy to clipboard<\/a>'');' & @CRLF & _
						'</script>' & @CRLF & _
						'</div>' & @CRLF & _
						'</div>' & @CRLF & _
						'<div class="codeSnippetContainerCode" dir="ltr" id="copytext1">' & @CRLF & _
						'<pre>' & @CRLF & _
						$sExample_Content & @CRLF & _
						'</pre>' & @CRLF & _
						'</div>' & @CRLF & _
						'</div>' & @CRLF & _
						'</div>' & @CRLF & _
						'</body>' & @CRLF & _
						'</html>'
			EndIf
		EndIf

		;Çàêðûâàåì òåãè Html'êè ôóíêöèé: Body, Html
		$sHtml_Content &= '</body>' & @CRLF & '</html>'
		#EndRegion Ôîðìèðóåì Html'êó ôóíêöèé

		;Ïèøåì ôàéë ôóíêöèé
		$hFunc_File = FileOpen($sDocsDir & "\funcs\" & $sFile & ".htm", 2 + 128)
		FileWrite($hFunc_File, $sHtml_Content)
		FileClose($hFunc_File)
	Next

	;Çàêðûâàåì òåãè: table, Body, Html
	FileWriteLine($hIndex_File, "</table>" & @CRLF & "</body>" & @CRLF & "</html>")

	;Çàêðûâàåì ôàéë èíäåêñà
	FileClose($hIndex_File)

	; Replace the generated Index.htm with a user defined Index.htm.
	; If <LibraryName>_Index.htm (library specific Index) exists in the AU3 Library File Directory then use this file as Index.htm
	; If <LibraryName>_Index.htm does not exist but a general Index.htm exists in the AU3 Library File Directory then use this file as Index.htm
	; If none of both files exists then the generated Index.htm is used.
	Local $sLibraryPath = StringLeft($sLibraryFile, StringInStr($sLibraryFile, "\", 0, -1))
	If FileExists($sLibraryPath & $sLibraryFile_Name & "_Index.htm") Then
		FileCopy($sLibraryPath & $sLibraryFile_Name & "_Index.htm", $sIndex_File, 1) ;~ modified MODIFY!!
	ElseIf FileExists($sLibraryPath & "Index.htm") Then
		FileCopy($sLibraryPath & "Index.htm", $sIndex_File, 1) ;~ modified MODIFY!!
	EndIf

	Return $sIndex_File
EndFunc   ;==>_AU3Lib_GenerateDocs_Proc

;$aHeaders[0][1-10] = Header key name
;$aHeaders[N][0] = Name
;$aHeaders[N][1] = Description
;$aHeaders[N][2] = Syntax
;$aHeaders[N][3] = Parameters
;$aHeaders[N][4] = Return values
;$aHeaders[N][5] = Author
;$aHeaders[N][6] = Modified
;$aHeaders[N][7] = Remarks
;$aHeaders[N][8] = Related
;$aHeaders[N][9] = Link
;$aHeaders[N][10] = Example
Func _AU3Lib_GetHeaders($sLibraryFile)
	If Not FileExists($sLibraryFile) Then Return SetError(1, 0, -1)

	Local $aLibHeaders = StringRegExp(FileRead($sLibraryFile), '(?s).*?(; #FUNCTION# =+.*?; =+).*?', 3)
	Local $iUbound = UBound($aLibHeaders) - 1
	Local $aHeaders[500][11], $aHeader_Params, $iCount, $sParam

	$aHeader_Params = _
			StringSplit( _
			'Name...........|Description....|Syntax.........|Parameters.....|Return values..|' & _
			'Author.........|Modified.......|Remarks........|Related........|Link...........|Example........', _
			'|')

	For $i = 0 To $iUbound
		If StringIsSpace($aLibHeaders[$i]) Then ContinueLoop

		$iCount += 1

		For $j = 1 To $aHeader_Params[0]
			$sParam = StringRegExpReplace($aLibHeaders[$i], '(?s).*; ' & $aHeader_Params[$j] & ': ?(.*?)[\r\n]; ([\w\s_]+\.+:|=+).*', '\1')
			If @extended = 0 Or $sParam = $aLibHeaders[$i] Then ContinueLoop

			$sParam = StringRegExpReplace($sParam, '(?m)^;', '')
			If StringIsSpace($sParam) Then $sParam = ''

			$aHeaders[0][$j - 1] = $aHeader_Params[$j]
			$aHeaders[$iCount][$j - 1] = StringStripWS($sParam, 3)
		Next
	Next

	ReDim $aHeaders[$iCount + 1][11]
	Return $aHeaders
EndFunc   ;==>_AU3Lib_GetHeaders

Func _AU3Lib_GetHtmlHeaderStr($sTitle, $sCss_Path = 'css')
	Return _
			'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN">' & @CRLF & _
			'<html>' & @CRLF & _
			'<head>' & @CRLF & _
			'	<title>' & $sTitle & '</title>' & @CRLF & _
			'	<meta charset=UTF-8">' & @CRLF & _ ;~ modified
			'	<link href="' & $sCss_Path & '/default.css" rel="stylesheet">' & @CRLF & _ ;~ modified
			'</head>' & @CRLF
EndFunc   ;==>_AU3Lib_GetHtmlHeaderStr

Func _AU3Lib_GetValidFileName($sString, $sPatern = '[*?\\/|:<>"]', $sReplace = '_')
	If StringIsSpace($sString) Then Return $sString

	$sString = StringRegExpReplace($sString, $sPatern, $sReplace)
	Return SetExtended(@extended, StringRegExpReplace($sString, '(' & $sReplace & '+)', $sReplace))
EndFunc   ;==>_AU3Lib_GetValidFileName

Func _AU3Lib_CompileHtmlToChm($sChm_File_Path, $sChm_File_Name)
	GUICtrlSetData($nStatus_Label, "Please wait... [Compiling to Chm]")

	#cs
	FileInstall(".\Resources\hhc.exe", @SystemDir & "\hhc.exe", 1)
	FileInstall(".\Resources\hha.dll", @SystemDir & "\hha.dll", 1)
	FileInstall(".\Resources\itcc.dll", @SystemDir & "\itcc.dll", 1)

	EnvSet("PATH", @SystemDir & "\hhc.exe;" & @SystemDir & "\hha.dll")
	RunWait(@SystemDir & '\regsvr32.exe /s "' & @SystemDir & '\itcc.dll"')
	#ce

	Local $sPathHTMHelpCompiler = @ScriptDir & "\Resources"

	EnvSet("PATH", $sPathHTMHelpCompiler & "\hhc.exe;" & $sPathHTMHelpCompiler & "\hha.dll")
	RunWait($sPathHTMHelpCompiler & '\regsvr32.exe /s "' & $sPathHTMHelpCompiler & '\itcc.dll"')

	Local $aFileList, $hFile, $sIndex_hhk_File_Content, $sTOC_hhc_File_Content, $sChmProject_hhp_File_Content

	Local $sIndex_hhk_File = $sChm_File_Path & "\Index.hhk"
	Local $sTOC_hhc_File = $sChm_File_Path & "\TOC.hhc"
	Local $sChmProject_hhp_File = $sChm_File_Path & "\" & $sChm_File_Name & ".hhp"
	Local $sChm_File = $sChm_File_Path & "\" & $sChm_File_Name & ".chm"

	$aFileList = _FileListToArray($sDocsDir & '\funcs', '*.htm', 1)

	If @error Then
		Return SetError(1, 0, 0)
	EndIf

	$sIndex_hhk_File_Content = _
			'<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">' & @CRLF & _
			'<HTML>' & @CRLF & _
			'<HEAD>' & @CRLF & _
			'<meta name="GENERATOR" content="Microsoft&reg; HTML Help Workshop 4.1">' & @CRLF & _
			'<!-- Sitemap 1.0 -->' & @CRLF & _
			'</HEAD><BODY>' & @CRLF & _
			'<UL>' & @CRLF

	$sTOC_hhc_File_Content = _
			'<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML//EN">' & @CRLF & _
			'<HTML>' & @CRLF & _
			'<HEAD>' & @CRLF & _
			'<meta name="GENERATOR" content="Microsoft&reg; HTML Help Workshop 4.1">' & @CRLF & _
			'<!-- Sitemap 1.0 -->' & @CRLF & _
			'</HEAD><BODY>' & @CRLF & _
			'<OBJECT type="text/site properties">' & @CRLF & _
			@TAB & '<param name="ImageType" value="Folder">' & @CRLF & _
			'</OBJECT>' & @CRLF & _
			'<UL>' & @CRLF & _
			@TAB & '<LI> <OBJECT type="text/sitemap">' & @CRLF & _
			@TAB & @TAB & '<param name="Name" value="' & $sDocsIndexHeader_Title & '">' & @CRLF & _
			@TAB & @TAB & '<param name="Local" value="index.htm">' & @CRLF & _
			@TAB & @TAB & '</OBJECT>' & @CRLF & _
			@TAB & '<UL>'

	$sChmProject_hhp_File_Content = _
			'[OPTIONS]' & @CRLF & _
			'Compatibility=1.1 or later' & @CRLF & _
			'Compiled file=' & $sChm_File_Name & '.chm' & @CRLF & _
			'Contents file=TOC.hhc' & @CRLF & _
			'Default Window=Main' & @CRLF & _
			'Default topic=index.htm' & @CRLF & _
			'Display compile progress=Yes' & @CRLF & _
			'Full-text search=Yes' & @CRLF & _
			'Index file=Index.hhk' & @CRLF & _
			'Language=0x409 English (United States)' & @CRLF & _
			'Title=' & $sDocsIndex_Title & @CRLF & _
			'' & @CRLF & _
			'[WINDOWS]' & @CRLF & _
			'Main=,"TOC.hhc","Index.hhk","index.htm",,,,,,0x63520,,0x280e,[100,100,1020,800],,,,,,,0' & @CRLF & _
			'' & @CRLF & _
			'[FILES]' & @CRLF

	For $i = 1 To $aFileList[0]
		$sIndex_hhk_File_Content &= _
				@TAB & '<LI> <OBJECT type="text/sitemap">' & @CRLF & _
				@TAB & @TAB & '<param name="Name" value="' & StringLeft($aFileList[$i], StringInStr($aFileList[$i], '.') - 1) & '">' & @CRLF & _
				@TAB & @TAB & '<param name="Local" value="funcs\' & $aFileList[$i] & '">' & @CRLF & _
				@TAB & @TAB & '</OBJECT>' & @CRLF

		$sTOC_hhc_File_Content &= _
				@TAB & @TAB & '<LI> <OBJECT type="text/sitemap">' & @CRLF & _
				@TAB & @TAB & @TAB & '<param name="Name" value="' & StringLeft($aFileList[$i], StringInStr($aFileList[$i], '.') - 1) & '">' & @CRLF & _
				@TAB & @TAB & @TAB & '<param name="Local" value="funcs\' & $aFileList[$i] & '">' & @CRLF & _
				@TAB & @TAB & @TAB & '</OBJECT>' & @CRLF

		$sChmProject_hhp_File_Content &= 'funcs\' & $aFileList[$i] & @CRLF
	Next

	$sIndex_hhk_File_Content &= _
			'</UL>' & @CRLF & _
			'</BODY></HTML>' & @CRLF

	$sTOC_hhc_File_Content &= _
			@TAB & '</UL>' & @CRLF & _
			'</UL>' & @CRLF & _
			'</BODY></HTML>' & @CRLF

	$sChmProject_hhp_File_Content &= _
			'css\h1_background.jpg' & @CRLF & _
			'' & @CRLF & _
			'[INFOTYPES]' & @CRLF & _
			'' & @CRLF

	$hFile = FileOpen($sIndex_hhk_File, 2)
	FileWrite($hFile, $sIndex_hhk_File_Content)
	FileClose($hFile)

	; Replace the generated TOC.hhc with a user defined TOC.hhc.
	; If <LibraryName>_TOC.hhc (library specific TOC) exists in the AU3 Library File Directory then use this file as TOC.hhc
	; If <LibraryName>_TOC.hhc does not exist but a general TOC.hhc exists in the AU3 Library File Directory then use this file as TOC.hhc
	; If none of both files exists then the generated TOC.hhc is used.
	Local $sLibraryPath = StringLeft($sLibraryFile, StringInStr($sLibraryFile, "\", 0, -1))
	If FileExists($sLibraryPath & $sLibraryFile_Name & "_TOC.hhc") Then
		FileCopy($sLibraryPath & $sLibraryFile_Name & "_TOC.hhc", $sTOC_hhc_File) ;~ modified MODIFY!!
	ElseIf FileExists($sLibraryPath & "TOC.hhc") Then
		FileCopy($sLibraryPath & "TOC.hhc", $sTOC_hhc_File) ;~ modified MODIFY!!
	Else
		$hFile = FileOpen($sTOC_hhc_File, 2)
		FileWrite($hFile, $sTOC_hhc_File_Content)
		FileClose($hFile)
	EndIf

	$hFile = FileOpen($sChmProject_hhp_File, 2)
	FileWrite($hFile, $sChmProject_hhp_File_Content)
	FileClose($hFile)

	FileDelete($sChm_File)
;~ 	RunWait(@SystemDir & '\hhc.exe "' & $sChm_File & '"', $sChm_File_Path, @SW_HIDE)
	RunWait($sPathHTMHelpCompiler & '\hhc.exe "' & $sChm_File & '"', $sChm_File_Path, @SW_HIDE)
EndFunc   ;==>_AU3Lib_CompileHtmlToChm
#EndRegion Core Functions

#Region Internal Functions
Func _HighlightExampleSyntax_CB_Event()
	$iHighlightExampleSyntax = Number(GUICtrlRead($nHighlightExampleSyntax_CB) = $GUI_CHECKED)
	$iHiglExmplSyntx_AddURLs = Number(GUICtrlRead($nHiglExmplSyntx_AddURLs_CB) = $GUI_CHECKED)

	If $iHighlightExampleSyntax Then
		GUICtrlSetState($nHiglExmplSyntx_AddURLs_CB, $GUI_ENABLE)
	Else
		GUICtrlSetState($nHiglExmplSyntx_AddURLs_CB, $GUI_DISABLE)
	EndIf
EndFunc   ;==>_HighlightExampleSyntax_CB_Event

Func _RegRead($sKeyName, $sValName, $sDefault = "")
	Local $sRet = RegRead($sKeyName, $sValName)
	If @error <> 0 Then $sRet = $sDefault
	Return $sRet
EndFunc   ;==>_RegRead
#EndRegion Internal Functions
